IF  NOT EXISTS (SELECT * FROM sys.objects 
					WHERE object_id = OBJECT_ID(N'[dbo].[CG_FND_VERBA_USO_PDV_VD_IT]') 
					AND type in (N'U')) 
begin
CREATE TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT](
	[CD_EMP] [int] NOT NULL,
	[CD_FND_VERBA_USO] [int] NOT NULL,
	[CD_FILIAL] [int] NOT NULL,
	[CD_VD] [int] NOT NULL,
	[CD_IT] [int] NOT NULL,
 CONSTRAINT [PK_CG_FND_VERBA_USO_PDV_VD_IT] PRIMARY KEY CLUSTERED 
(
	[CD_EMP] ASC,
	[CD_FND_VERBA_USO] ASC,
	[CD_FILIAL] ASC,
	[CD_VD] ASC,
	[CD_IT] ASC
)WITH (PAD_INDEX = OFF, STATISTICS_NORECOMPUTE = OFF, IGNORE_DUP_KEY = OFF, ALLOW_ROW_LOCKS = ON, ALLOW_PAGE_LOCKS = ON) ON [PRIMARY]
) ON [PRIMARY]


ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PDV_VD_IT_CD_EMP]  DEFAULT ((0)) FOR [CD_EMP]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PDV_VD_IT_CD_FND_VERBA_USO]  DEFAULT ((0)) FOR [CD_FND_VERBA_USO]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PDV_VD_IT_CD_FILIAL]  DEFAULT ((0)) FOR [CD_FILIAL]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PDV_VD_IT_CD_VD]  DEFAULT ((0)) FOR [CD_VD]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT] ADD  CONSTRAINT [DF_CG_FND_VERBA_USO_PDV_VD_IT_CD_IT]  DEFAULT ((0)) FOR [CD_IT]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_USO_PDV_VD_IT_CG_FND_VERBA_USO] FOREIGN KEY([CD_FND_VERBA_USO], [CD_EMP])
REFERENCES [dbo].[CG_FND_VERBA_USO] ([CD_FND_VERBA_USO], [CD_EMP])

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT] CHECK CONSTRAINT [FK_CG_FND_VERBA_USO_PDV_VD_IT_CG_FND_VERBA_USO]

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT]  WITH CHECK ADD  CONSTRAINT [FK_CG_FND_VERBA_USO_PDV_VD_IT_PDV_VD_IT] FOREIGN KEY([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IT])
REFERENCES [dbo].[PDV_VD_IT] ([CD_EMP], [CD_FILIAL], [CD_VD], [CD_IT])

ALTER TABLE [dbo].[CG_FND_VERBA_USO_PDV_VD_IT] CHECK CONSTRAINT [FK_CG_FND_VERBA_USO_PDV_VD_IT_PDV_VD_IT]
end